<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Pickup;

use Gls\GlsPoland\AdePlus\Common\Id;
use Gls\GlsPoland\AdePlus\ConsignmentsApiClientInterface;
use Gls\GlsPoland\AdePlus\Printout\PickupReceipt;
use Gls\GlsPoland\AdePlus\Printout\PickupReceiptPrintMode;

interface ClientInterface extends ConsignmentsApiClientInterface
{
    public function createPickup(string $description, int ...$consignmentIds): Id;

    /**
     * @return iterable<ConsignmentIdsBinding>
     */
    public function getConsignmentIdsBindings(int $pickupId): iterable;

    public function getReceipt(int $pickupId, PickupReceiptPrintMode $printMode): PickupReceipt;
}
