<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Pickup;

use Gls\GlsPoland\AdePlus\Authorization\AuthorizedRequest;
use Gls\GlsPoland\AdePlus\Printout\PickupReceiptPrintMode;

final class GetReceipt extends AuthorizedRequest
{
    /**
     * @var int
     */
    private $id;

    /**
     * @var string
     */
    private $mode;

    public function __construct(int $pickupId, PickupReceiptPrintMode $printMode)
    {
        $this->id = $pickupId;
        $this->mode = (string) $printMode;
    }

    public function jsonSerialize(): array
    {
        return [
            'id' => $this->id,
            'mode' => $this->mode,
        ];
    }

    public function getPickupId(): int
    {
        return $this->id;
    }

    public function withPickupId(int $id): GetReceipt
    {
        $new = clone $this;
        $new->id = $id;

        return $new;
    }

    public function getPrintMode(): PickupReceiptPrintMode
    {
        return PickupReceiptPrintMode::from($this->mode);
    }

    public function withPrintMode(PickupReceiptPrintMode $printMode): GetReceipt
    {
        $new = clone $this;
        $new->mode = (string) $printMode;

        return $new;
    }
}
