<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\Consignment\DTO\ServiceDetails;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

final class ShopDeliveryServiceDetailsType extends AbstractType
{
    use TranslatorAwareTrait;

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('parcelShopId', TextType::class, [
                'label' => $this->getTranslator()->trans('ParcelShop', [], 'Modules.Glspoland.Consignment'),
                'constraints' => new NotBlank(),
            ])
            ->add('documentReturn', HiddenType::class, [
                'data' => false,
            ])
            ->add('saturdayDelivery', HiddenType::class, [
                'data' => false,
            ])
            ->add('timeDefiniteService', HiddenType::class, [
                'data' => null,
            ])
            ->add('cashOnDeliveryAmount', HiddenType::class, [
                'data' => null,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefault('data_class', ServiceDetails::class);
    }
}
