<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Translation;

use Symfony\Component\Translation\IdentityTranslator;
use Symfony\Component\Translation\TranslatorInterface as LegacyTranslatorInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

if (interface_exists(TranslatorInterface::class)) {
    trait TranslatorAwareTrait
    {
        /**
         * @var TranslatorInterface
         */
        protected $translator;

        /**
         * @required
         *
         * @return static
         */
        public function setTranslator(TranslatorInterface $translator): self
        {
            $this->translator = $translator;

            return $this;
        }

        protected function getTranslator(): TranslatorInterface
        {
            return $this->translator ?? ($this->translator = new IdentityTranslator());
        }
    }
} else {
    trait TranslatorAwareTrait
    {
        /**
         * @var LegacyTranslatorInterface
         */
        protected $translator;

        /**
         * @required
         *
         * @return static
         */
        public function setTranslator(LegacyTranslatorInterface $translator): self
        {
            $this->translator = $translator;

            return $this;
        }

        protected function getTranslator(): LegacyTranslatorInterface
        {
            return $this->translator ?? ($this->translator = new IdentityTranslator());
        }
    }
}
